from abc import ABC, abstractmethod


class CacheBase(ABC):
    def __init__(self):
        pass

    @abstractmethod
    def set_cur_t(self, cur_t):
        """
        Set the current time or state for cache operations.
        """
        pass

    @abstractmethod
    def set_invert_or_generate(self, mode):
        """
        Set the mode for saving cache
        """
        pass

    @abstractmethod
    def save_cache_to_file(self):
        """
        Save the current cache to a specified file.
        """
        pass

    @abstractmethod
    def load_cache_from_file(self):
        """
        Load the cache from a specified file.
        """
        pass

    @abstractmethod
    def save_cache(self, *args):
        """
        Save the cache at a specific time or state to a file.
        """
        pass

    @abstractmethod
    def load_cache(self, *args):
        """
        Load the cache for a specific time or state from a file.
        """
        pass

    def reset_cache(self):
        """
        Reset the cache to its initial state.
        """
        pass
